clear();
clc();
close all;                              	%Plots schließen

%KONFIGURATION---------------------------------------------------------------------
Y                   = @(x)   (-0.5*(x.^4))+(4*(x.^3))-(10*(x.^2))+(8.5*x)+1;
dYdX                = @(x,y) (-2*(x.^3))+(12*(x.^2))-(20*x)+8.5;
Anfangswert         = 1;                    %Anfangswert y0
obereGrenze         = 4.0;                  %Intervall obere Grenze
untereGrenze        = 0.0;                  %Intervall untere Grenze
Quantisierung       = 8;                    %Zerlegung des Intervals in Steigungsnäherungen
sKommastellenDouble = '%.8f';               %Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%INITIALISIERUNG-------------------------------------------------------------------
X_INTERVALLSTUFEN(:)=untereGrenze:(obereGrenze-untereGrenze)/Quantisierung:obereGrenze;
aWERTETABELLE(1,:)=["i","Yi+1 = Yi + h*f(Xi,Yi) = ","Funktionswert","X-Wert"];
aWERTETABELLE(2,:)=["-1","Y0 = ",num2str(Anfangswert,sKommastellenDouble),num2str(X_INTERVALLSTUFEN(1))];
                
%BERECHNUNG------------------------------------------------------------------------
h=(obereGrenze-untereGrenze)/Quantisierung;
for(i=0:1:Quantisierung-1)
    aWERTETABELLE(i+3,1)=num2str(i);
    aWERTETABELLE(i+3,2)=strcat("Y",num2str(i+1)," = Y",num2str(i)," + h*f(X",num2str(i),",Y",num2str(i),") = ");
    aWERTETABELLE(i+3,3)=num2str(str2double(aWERTETABELLE(i+2,3))+(h*dYdX(X_INTERVALLSTUFEN(i+1),str2double(aWERTETABELLE(i+2,3)))),sKommastellenDouble);
    aWERTETABELLE(i+3,4)=num2str(X_INTERVALLSTUFEN(i+2));
end
disp(aWERTETABELLE);

%FUNKTIONSPLOT---------------------------------------------------------------------
xACHSE              = @(x) 0*x;
Inkrement=100;
X(:)=untereGrenze:(obereGrenze-untereGrenze)/Inkrement:obereGrenze;
plot(X,Y(X),'color','blue');
hold on;
plot(X_INTERVALLSTUFEN,str2double(aWERTETABELLE(2:end,3)),'color','red');
hold on;
plot(X,xACHSE(X),'color','black');
hold on;                                											%Warten bis zur Plotausgabe
xlabel('x');
ylabel('y');
grid on;
grid minor;

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aWERTETABELLE                  									%Workspace aufräumen